<?php
/*
    =========================================
        DataBase
    =========================================
*/

class DataBase
{
  private static $name = DB_NAME;
  private static $user = DB_USER;
  private static $password = DB_PASSWORD;
  private static $host = DB_HOST;

  private static $sth;
  public static $pdo;

  public static function init()
  {
    self::$pdo = self::connect();
  }

  public static function prepare($query)
  {
    return self::$sth = self::$pdo->prepare($query);
  }

  public static function execute($array_infos)
  {
    return self::$sth->execute($array_infos);
  }

  public static function last_insert_id()
  {
    return self::$pdo->lastInsertId();
  }

  private static function connect ()
  {
    try
    {
        $newdb = new PDO('mysql:host=' . self::$host . ';dbname=' . self::$name , self::$user, self::$password);
        $newdb->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
        $newdb->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING);
        return $newdb;
    }
    catch (exception $e)
    {
        echo 'Impossible de se connecter à la base de donnés : ';
        echo $e->getMessage();
        return false;
    }
  }
}
