<?php
/*
    =========================================
        MetaHandler
    =========================================
*/

class MetaHandler
{
  private static $meta_data = [];

  public static function add_custom_data($data_array)
  {
    foreach ($data_array as $key => $value)
      self::$meta_data[$key] = $value;
  }

  private static function get_canonical()
  {
    $actual_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

    $actual_url_parsed = parse_url ( $actual_url );

    return self::$meta_data['canonical'] = rtrim(SITE_URL, '/') . $actual_url_parsed['path'];
  }

  private static function get_alternate()
  {
    $actual_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

    $actual_url_parsed = parse_url ( $actual_url );
    $alternate_lang = LANG == 'fr' ? 'en' : 'fr';
    $alternate_url_path = substr_replace( $actual_url_parsed['path'], '/'.$alternate_lang, 0,  3 );

    return self::$meta_data['alternate'] = SITE_URL . $alternate_url_path;
  }

  public static function process()
  {
    self::$meta_data['title'] = '';
    self::$meta_data['description'] = '';
    self::$meta_data['alternate_lang'] = LANG == 'fr' ? 'en' : 'fr';
    self::get_canonical();
    self::get_alternate();
  }

  public static function get_data()
  {
    return self::$meta_data;
  }

}
