<?php
/*
    =========================================
        BCKND Sections
    =========================================
*/


// ---------------------------         IMAGE          --------------------------

function image ( $section, $count = false )
{
  $delay = $count ? ($count - 1) * 400 + 1000 : 1400;

  global $db, $post;

  $img_id = $section['content']['id'];

  $img = get_media( $img_id );

  if ( $img )
  {
    $legend = "";

    if ( $post['type'] === 'blog' )
    {
      if ( $img['display_name'] === "" || $img['display_name'] === " " )
      {
        // Pas de titre mais une legende
        $legend = "<div class=\"img-legend\">" . $img['caption'] . "</div>";
      }
      else if ( $img['caption'] === "" || $img['caption'] === " " )
      {
        // Pas de légende mais un titre d'oeuvre
        $legend = "<div class=\"img-legend\"><i>" . $img['display_name'] . "</i></div>";
      }
      else
      {
        // Les deux
        $legend = "<div class=\"img-legend\"><i>" . $img['display_name'] . "</i>&nbsp;&nbsp;—&nbsp;&nbsp;" . $img['caption'] . "</div>";
      }
    }

    $r = "<div class=\"cstm-sec img-sec \">";
    $r .=  "<div class=\"img-wrapper _a\" data-a=\"d\">";
    $r .=    "<img class=\"_scale _lazy\" src=\"\" data-src=\"".UPLOADS_URL.'img/large/'.$img['slug']."\" alt=".$img['alt'].">";
    $r .=  "</div>";
    $r .=  $legend;
    $r .= "</div>";

    return $r;
  }
  else
  {
    return "";
  }
}


// ---------------------------         VIDEO          --------------------------

function video ( $section )
{
  global $db;

  $video_id = $section['content']['id'];

  $sth = $db->pdo->prepare('
  SELECT *
  FROM uploads
  WHERE ID = ?
  ');

  $sth->execute( array( $video_id ) );

  $video = $sth->fetchAll();

  if ( count( $video ) > 0 )
  {
    $video = $video[0];

    $poster = get_media( $video['poster'] );
    if (!$poster) $poster = "";
    else $poster = UPLOADS_URL.'img/large/'. $poster['slug'];
    // Post thumb poster
    $poster = $poster === '' ? '' : 'poster="' . $poster . '"';

    $r = "<div class=\"cstm-sec video-sec " . $section["options"]['size'] . " " . $section["options"]['background_color'] . "-sec\">";
    $r .=  "<div class=\"video-wrapper\">";
    $r .=    "<video src=\"".UPLOADS_URL.'video/'.$video['slug']."\" ".$poster." muted autoplay loop playsinline></video>";
    $r .=  "</div>";
    $r .= "</div>";

    return $r;
  }
  else
  {
    return "";
  }


}


// --------------------------         DOUBLE          --------------------------

function double ( $section )
{
  $r = '<div class="cstm-sec double-sec">';

  $count = 1;

  foreach ($section['content']['sections'] as $key => $value)
  {
    $r .= '<div class="double-sec-wrapper">';
    if ( function_exists ($value["type"]) )
    {
      $r .= nl2br($value["type"]( $value, $count ));
    }
    else
    {
      $r .= "";
      // $r .= "<div><p>Error: this type of section is not defined</p></div>";
    }
    $r .= '</div>';

    $count++;
  }

  $r .= '</div>';

  return $r;
}


// --------------------------         TRIPLE          --------------------------

function triple ( $section )
{
  $r = '<div class="cstm-sec triple-sec">';

  $count = 1;

  foreach ($section['content']['sections'] as $key => $value)
  {
    $r .= '<div class="triple-sec-wrapper">';
    if ( function_exists ($value["type"]) )
    {
      $dialing = false;

      if ( $value['type'] === 'text' )
      {
        $dialing = true;
      }
      $r .= nl2br($value["type"]( $value, $count, $dialing ));
    }
    else
    {
      $r .= "";
      // $r .= "<div><p>Error: this type of section is not defined</p></div>";
    }
    $r .= '</div>';

    $count++;
  }

  $r .= '</div>';

  return $r;
}


// --------------------------         TEXTE          ---------------------------

function text ( $section, $count = false, $dialing = false )
{
  $delay = $count ? ($count - 1) * 400 + 1000 : 1400;

  $r = "<div class=\"cstm-sec text-sec " . $section["options"]['size'] . " " . $section["options"]['alignment'] . " _appear\"  data-anim=\"slide\" data-duration=\"" . $delay . "\" data-color=\"" . $section["options"]['background_color'] . "\">";
  $r .= "<div class=\"_op_overlay\"></div>";
  $r .= "<div class=\"text-wrapper \">";
  if ( $dialing )
  {
    $r .= '<div class="text-triple-num">' . $count . '</div>';
  }
  if ( $section["content"]["title"] != "" && $section["content"]["title"] != " " )
  {
    $r .= "<h3>" . $section["content"]['title'] . "</h3>";
  }
  $r .= "<p class=\"\">" . $section["content"]['content'] . "</p>";
  $r .= "</div>";
  $r .= "<div class=\"_overlay\"></div>";
  $r .= "</div>";

  return $r;

}


// --------------------------         TITRE          ---------------------------

function title ( $section, $count = false )
{
  $delay = $count ? ($count - 1) * 400 + 1000 : 1400;

  $r = "<div class=\"cstm-sec title-sec " . $section["options"]['size'] . " " . $section["options"]['alignment'] . " _appear\"  data-anim=\"slide\" data-duration=\"" . $delay . "\" data-color=\"" . $section["options"]['background_color'] . "\">";
  $r .= "<div class=\"_op_overlay\"></div>";
  $r .= "<div class=\"title-wrapper \">";

  $r .= "<" . $section["options"]['size'] . ">" . $section["content"]['title'] . "</" . $section["options"]['size'] . ">";
  $r .= "</div>";
  $r .= "<div class=\"_overlay\"></div>";
  $r .= "</div>";

  return $r;

}


// ------------------------         CITATION          --------------------------

function citation ( $section, $count = false )
{
  $delay = $count ? ($count - 1) * 600 + 600 : 1400;

  $r =  "<div class=\"cstm-sec quote-sec _appear\" data-anim=\"slide\" data-duration=\"" . $delay . "\" data-color=\"" . $section["options"]['background_color'] . "\">";
  $r .=   "<div class=\"_op_overlay\"></div>";
  $r .=   "<div class=\"quote-wrapper\">";
  $r .=     "<p class=\"\">" . $section["content"]['content'] . "</p>";
  $r .=   "</div>";
  $r .=   '<div class="author-wrapper"><span>' . $section["content"]['author'] . '</span></div>';
  $r .=   "<div class=\"_overlay\"></div>";
  // $r .=   "</div>";
  $r .= "</div>";

  return $r;

}


// --------------------------         LISTE          ---------------------------

function list_ul ( $section ) {

  global $db;

  $ul_list = "<ul>";

  foreach ($section['content']['text'] as $list_item => $text) {

      $ul_list .= "<li class=\"phx-li-item\">";
      $ul_list .=    "<p class=\"p-m\">".$text."</p>";
      $ul_list .= "</li>";

  }

  $ul_list .= "</ul>";

  $r = "<div class=\"cstm-sec ul_list-sec " . $section["options"]['background_color'] . "-sec\">";
  $r .= "<div class=\"ul_list-wrapper\">";
  $r .= $ul_list;
  $r .= "</div>";
  $r .= "</div>";

  return $r;

}


// --------------------------         TITRE          ---------------------------

function heading_1 ( $section ) {

  global $db;

  $heading = "<h2>";

  $heading .= $section["content"]['text'];

  $heading .= "</h2>";

  $r = "<div class=\"cstm-sec heading-sec " . $section["options"]['background_color'] . "-sec\">";
  $r .= "<div class=\"heading-wrapper\">";
  $r .= $heading;
  $r .= "<div class=\"line\"></div>";
  $r .= "</div>";
  $r .= "</div>";

  return $r;

}
