<?php

$ml_text = get_content_from_json("nav");

$languages = json_decode(file_get_contents(INC . "siteData/site-data.json"), true)["languages"];

$tab_menu = ["offres", "ref", "team"];
 ?>

<nav class="nav">
  <div class="nav-top">
    <div class="nav-logo _top _logo hide">
      <div class="logo">
        <span class="logo-0 logo-word">L'agence</span><span class="logo-1 logo-word">pigment</span>
        <?php for ($i=0; $i < 4; $i++) {
          echo '<div class="logo-line"></div>';
        } ?>
      </div>
    </div>
    <div class="nav-menu-cont _nav-menu">
      <div class="nav-menu-bg _nav-bg"></div>
      <ul class="nav-menu">
        <li class="_nav-menu-i nav-menu-item hide news-btn">
          <span class="  _news-open">News</span>
          <div class="l-btn-line"></div>
          <div class="l-btn-line"></div>
        </li>
		<?php for($i = 0 ; $i < 3 ; $i++) { ?>
        <li class="_nav-menu-i nav-menu-item hide _sec-btn" data-sec="<?= $tab_menu[$i] ?>">
          <span class=" "><?= $ml_text[LANG]['menu_'.$i] ?></span>
          <div class="l-btn-line"></div>
          <div class="l-btn-line"></div>
        </li>
		<?php } ?>
        <?php foreach ($languages as $language): ?>
        
          <?php if ($language != LANG): ?>
          <li class="_nav-menu-i nav-menu-item nav-menu-itemLang hide">
            <a href="/<?= $language ?>">
              <span class=" "><?= strtoupper($language) ?></span>
              <div class="l-btn-line"></div>
              <div class="l-btn-line"></div>
            </a>
          </li>
          <?php endif; ?>
        <?php endforeach; ?>
      </ul>
    </div>
    <div class="btn-close g-center _nav-ref-btn">
      <div class="btn-close-l-wrapper">
        <div class="btn-close-l hide"></div>
      </div>
      <div class="btn-close-l-wrapper">
        <div class="btn-close-l hide"></div>
      </div>
    </div>
    <div class="_m-menu-open">
      <div class="mobile-l-wrapper">
        <div class="mobile-l hide"></div>
      </div>
      <div class="mobile-l-wrapper">
        <div class="mobile-l hide"></div>
      </div>
      <div class="mobile-l-wrapper">
        <div class="mobile-l hide"></div>
      </div>
    </div>
  </div>
  <div class="nav-bot">
    <div class="nav-line _progbar">

      <div class="nav-line-wrapper _progbar-container">

        <?php

        $sec = [
          'header',
          'offres',
          'ref',
          'team',
        ];

         ?>

        <?php  $index = 1; foreach ($sec as $sec_name): ?>
          <div class="nav-line-dot _nav-dot hide" data-sec="<?= $sec_name ?>">
            <div class="n-dot"></div>
            <div class="n-line"><div></div></div>
            <div class="n-index"><span>0<?= $index ?></span></div>
          </div>
          <?php if ($index!=4): ?>
            <div class="nav-line-l-wrapper" >
              <div class="nav-line-l _nav-line hide" data-sec="<?= $sec_name ?>"><div></div></div>
            </div>
          <?php endif; ?>
        <?php $index++; endforeach; ?>

      </div>

    </div>
  </div>
</nav>
